<?php

require_once 'lib/user_input_handler_registry.php';

class MainEntryHandler implements UserInputHandler
{
    public function __construct()
    {
        UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    public function get_handler_id()
    {
        return 'entry';
    }

    public function custom_action($control_id, $params=null)
    {
        return UserInputHandlerRegistry::create_action($this,
            $control_id, $params);
    }

    private function ensure_sources_shown_initialized(&$plugin_cookies)
    {
        if (!isset($plugin_cookies->sources_shown))
        {
            $plugin_cookies->sources_shown =
                HD::get($plugin_cookies, 'status', 0) ? "yes" : "no";
        }
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        hd_print('entry handler D: handle_user_input:');
        foreach ($user_input as $key => $value)
            hd_print("  $key => $value");

        $control_id = HD::get($user_input, 'control_id', '');

        $this->ensure_sources_shown_initialized($plugin_cookies);

        if ($control_id == 'root' || $control_id == 'setup')
            return ActionFactory::open_folder(SetupScreen::ID, 'CloudDrive2');

        if ($control_id == 'sources')
        {
            $ffset = ConfigUtils::load_firmware_features();
            $with_sdcard = isset($ffset['url_sdcard']);

            $builtin_name = MainHelper::builtin_memory_folder_name();

            $url = $with_sdcard ?
                "sdcard://$builtin_name/CloudDrive" :
                'internal_memory://CloudDrive';

            // For legacy support only.
            if (!$with_sdcard && HD::is_fw_apk())
            {
                $props = array('show_builtin_memory_item' => '');
                HD::partial_load_properties_file(
                    '/config/settings.properties', $props);
                if ($props['show_builtin_memory_item'] == 'all_android_folders')
                    $url = "internal_memory://$builtin_name/CloudDrive";
            }

            hd_print("D: sources url is: $url");

            return ActionFactory::launch_media_url_ext(
                "embedded_app://{name=file_browser}{url=$url}",
                T::g('built_in_memory_title'));
        }

        return null;
    }
}

?>
