#!/bin/sh

datadir=$FS_PREFIX/flashdata/plugins_data/clouddrive2
cookies=$FS_PREFIX/config/clouddrive2_plugin_cookies.properties
killall_file=$FS_PREFIX/tmp/run/shutdown_killall.txt

if [ "$1" = 'boot' ]; then
  thisdir=`dirname "$0"`
  pdir=`cd $thisdir/.. && pwd`

  if [ ! -d "$datadir/clouddrive" ]; then
    sh $thisdir/deploy.sh
  fi
fi

grep -q "^clouddrive$" "$killall_file" 2>/dev/null \
  || echo "clouddrive" >>"$killall_file"

if grep -q 'status = 1' $cookies 2>/dev/null;
then
  echo "Starting CD2: $datadir/clouddrive/run.sh"
  /system/dunehd/dunehd_service "do" $datadir/clouddrive/run.sh
else
  echo "CD2 disabled"
fi
