#!/bin/sh

thisdir=`dirname "$0"`
pdir=`cd $thisdir/.. && pwd`
datadir=$FS_PREFIX/flashdata/plugins_data/clouddrive2

echo "Unpacking tgz..."
cd $datadir
tar xfz $pdir/clouddrive.tgz
/system/dunehd/dunehd_service "do" chmod -R +x $datadir/clouddrive
echo "Unpacking tgz: done"

ro_config_file=
if [ -f "$FS_PREFIX/config/ro_config.properties" ]; then
    ro_config_file="$FS_PREFIX/config/ro_config.properties"
elif [ -f "$FS_PREFIX/firmware/config/ro_config.properties" ]; then
    ro_config_file="$FS_PREFIX/firmware/config/ro_config.properties"
fi

if [ -n "$ro_config_file" ]; then
    builtin_memory_folder_name=`cat "$ro_config_file" | grep builtin_memory_folder_name | awk -F '=' '{print $2}' | sed 's/ //g'`
    if [ -n "$builtin_memory_folder_name" ]; then
        sed -i "s;DuneHD/CloudDrive;$builtin_memory_folder_name/CloudDrive;"  "$datadir/clouddrive/CloudDrive2/config.toml"
    fi
fi
