<?php

/**
 * NOTE: this file must be UTF-8 encoded
 */
class Lang
{
    private static $VALUES;

    public static function static_init()
    {
        self::$VALUES = array(
           array('english', 'English', 'en'),
           array('french', 'Français', 'fr'),
           array('german', 'Deutsch', 'de'),
           array('dutch', 'Nederlandse', 'nl'),
           array('spanish', 'Español', 'es'),
           array('italian', 'Italiano', 'it'),
           array('russian', 'Русский', 'ru'),
           array('ukrainian', 'Українська', 'uk'),
           array('romanian', 'Român', 'ro'),
           array('hungarian', 'Magyar', 'hu'),
           array('polish', 'Polski', 'pl'),
           array('greek', 'Ελληνικά', 'el'),
           array('danish', 'Dansk', 'da'),
           array('czech', 'Čeština', 'cs'),
           array('swedish', 'Svenska', 'sv'),
           array('estonian', 'Eesti', 'et'),
           array('slovak', 'Slovenčina', 'sk'),
           array('turkish', 'Türk', 'tr'),
           array('hebrew', 'עברית', 'he'),
           array('chinese', '中文', 'zh'),
           array('chinese_simplified', '中文', 'zh'),
           array('chinese_traditional', '中文', 'zh'),
           array('japanese', '日本語', 'ja'),
           array('abkhazian', 'Abkhazian', 'ab'),
           array('afan', 'Afan', 'om'),
           array('afar', 'Afar', 'aa'),
           array('afrikaans', 'Afrikaans', 'af'),
           array('albanian', 'Albanian', 'sq'),
           array('amharic', 'Amharic', 'am'),
           array('arabic', 'Arabic', 'ar'),
           array('armenian', 'Armenian', 'hy'),
           array('assamese', 'Assamese', 'as'),
           array('aymara', 'Aymara', 'ay'),
           array('azerbaijani', 'Azerbaijani', 'az'),
           array('bashkir', 'Bashkir', 'ba'),
           array('basque', 'Basque', 'eu'),
           array('bengali', 'Bengali', 'bn'),
           array('bhutani', 'Bhutani', 'dz'),
           array('bihari', 'Bihari', 'bh'),
           array('bislama', 'Bislama', 'bi'),
           array('breton', 'Breton', 'br'),
           array('bulgarian', 'Bulgarian', 'bg'),
           array('burmese', 'Burmese', 'my'),
           array('byelorussian', 'Byelorussian', 'be'),
           array('cambodian', 'Cambodian', 'km'),
           array('catalan', 'Catalan', 'ca'),
           array('corsican', 'Corsican', 'co'),
           array('croatian', 'Croatian', 'hr'),
           array('esperanto', 'Esperanto', 'eo'),
           array('faroese', 'Faroese', 'fo'),
           array('fiji', 'Fiji', 'fj'),
           array('finnish', 'Finnish', 'fi'),
           array('frisian', 'Frisian', 'fy'),
           array('galician', 'Galician', 'gl'),
           array('georgian', 'Georgian', 'ka'),
           array('greenlandic', 'Greenlandic', 'kl'),
           array('guarani', 'Guarani', 'gn'),
           array('gujarati', 'Gujarati', 'gu'),
           array('hausa', 'Hausa', 'ha'),
           array('hindi', 'Hindi', 'hi'),
           array('icelandic', 'Icelandic', 'is'),
           array('indonesian', 'Indonesian', 'id'),
           array('interlingua', 'Interlingua', 'ia'),
           array('interlingue', 'Interlingue', 'ie'),
           array('inuktitut', 'Inuktitut', 'iu'),
           array('inupiak', 'Inupiak', 'ik'),
           array('irish', 'Irish', 'ga'),
           array('javanese', 'Javanese', 'jv'),
           array('kannada', 'Kannada', 'kn'),
           array('kashmiri', 'Kashmiri', 'ks'),
           array('kazakh', 'Kazakh', 'kk'),
           array('kinyarwanda', 'Kinyarwanda', 'rw'),
           array('kirghiz', 'Kirghiz', 'ky'),
           array('kurundi', 'Kurundi', 'rn'),
           array('korean', 'Korean', 'ko'),
           array('kurdish', 'Kurdish', 'ku'),
           array('laothian', 'Laothian', 'lo'),
           array('latin', 'Latin', 'la'),
           array('latvian', 'Latvian', 'lv'),
           array('lingala', 'Lingala', 'ln'),
           array('lithuanian', 'Lithuanian', 'lt'),
           array('macedonian', 'Macedonian', 'mk'),
           array('malagasy', 'Malagasy', 'mg'),
           array('malay', 'Malay', 'ms'),
           array('malayalam', 'Malayalam', 'ml'),
           array('maltese', 'Maltese', 'mt'),
           array('maori', 'Maori', 'mi'),
           array('marathi', 'Marathi', 'mr'),
           array('moldavian', 'Moldavian', 'mo'),
           array('mongolian', 'Mongolian', 'mn'),
           array('nauru', 'Nauru', 'na'),
           array('nepali', 'Nepali', 'ne'),
           array('norwegian', 'Norwegian', 'no'),
           array('occitan', 'Occitan', 'oc'),
           array('oriya', 'Oriya', 'or'),
           array('pashto', 'Pashto', 'ps'),
           array('persian', 'Persian', 'fa'),
           array('portuguese', 'Portuguese', 'pt'),
           array('punjabi', 'Punjabi', 'pa'),
           array('quechua', 'Quechua', 'qu'),
           array('rhaeto_romance', 'Rhaeto-romance', 'rm'),
           array('samoan', 'Samoan', 'sm'),
           array('sangho', 'Sangho', 'sg'),
           array('sanskrit', 'Sanskrit', 'sa'),
           array('gaelic', 'Gaelic', 'gd'),
           array('serbian', 'Serbian', 'sr'),
           array('sesotho', 'Sesotho', 'st'),
           array('setswana', 'Setswana', 'tn'),
           array('shona', 'Shona', 'sn'),
           array('sindhi', 'Sindhi', 'sd'),
           array('singhalese', 'Singhalese', 'si'),
           array('siswati', 'Siswati', 'ss'),
           array('slovenian', 'Slovenian', 'sl'),
           array('somali', 'Somali', 'so'),
           array('sundanese', 'Sundanese', 'su'),
           array('swahili', 'Swahili', 'sw'),
           array('tagalog', 'Tagalog', 'tl'),
           array('tajik', 'Tajik', 'tg'),
           array('tamil', 'Tamil', 'ta'),
           array('tatar', 'Tatar', 'tt'),
           array('telugu', 'Telugu', 'te'),
           array('thai', 'Thai', 'th'),
           array('tibetan', 'Tibetan', 'bo'),
           array('tigrinya', 'Tigrinya', 'ti'),
           array('tonga', 'Tonga', 'to'),
           array('tsonga', 'Tsonga', 'ts'),
           array('turkmen', 'Turkmen', 'tk'),
           array('twi', 'Twi', 'tw'),
           array('uigur', 'Uigur', 'ug'),
           array('urdu', 'Urdu', 'ur'),
           array('uzbek', 'Uzbek', 'uz'),
           array('vietnamese', 'Vietnamese', 'vi'),
           array('volapuk', 'Volapuk', 'vo'),
           array('welsh', 'Welsh', 'cy'),
           array('wolof', 'Wolof', 'wo'),
           array('xhosa', 'Xhosa', 'xh'),
           array('yiddish', 'Yiddish', 'yi'),
           array('yoruba', 'Yoruba', 'yo'),
           array('zhuang', 'Zhuang', 'za'),
           array('zulu', 'Zulu', 'zu'),
        );
    }

    public static function get_code_by_id($id)
    {
        foreach (self::$VALUES as $v)
        {
            if ($v[0] == $id)
                return $v[2];
        }
        return null;
    }
}

?>
