<?php
///////////////////////////////////////////////////////////////////////////

abstract class AbstractTv
{
    private $favorites_supported;

    public function __construct($favorites_supported)
    {
        $this->favorites_supported = $favorites_supported;
    }

    public function is_favorites_supported()
    {
        return $this->favorites_supported;
    }

    public function is_favorite_channel_id($channel_id, &$plugin_cookies)
    {
        if (!$this->favorites_supported)
            return false;

        $fav_channel_ids = $this->get_fav_channel_ids($plugin_cookies);

        $k = array_search($channel_id, $fav_channel_ids);

        return $k !== false;
    }

    public function change_tv_favorites($fav_op_type, $channel_id, &$plugin_cookies)
    {
        $fav_channel_ids = $this->get_fav_channel_ids($plugin_cookies);

        if ($fav_op_type === PLUGIN_FAVORITES_OP_ADD)
        {
            array_push($fav_channel_ids, $channel_id);
        }
        else if ($fav_op_type === PLUGIN_FAVORITES_OP_REMOVE)
        {
            $k = array_search($channel_id, $fav_channel_ids);

            if ($k !== false)
                unset ($fav_channel_ids[$k]);
        }
        else if ($fav_op_type === PLUGIN_FAVORITES_OP_MOVE_UP)
        {
            $k = array_search($channel_id, $fav_channel_ids);

            if ($k !== false && $k !== 0)
            {
                $t = $fav_channel_ids[$k - 1];
                $fav_channel_ids[$k - 1] = $fav_channel_ids[$k];
                $fav_channel_ids[$k] = $t;
            }
        }
        else if ($fav_op_type === PLUGIN_FAVORITES_OP_MOVE_DOWN)
        {
            $k = array_search($channel_id, $fav_channel_ids);

            if ($k !== false && $k !== count($fav_channel_ids) - 1)
            {
                $t = $fav_channel_ids[$k + 1];
                $fav_channel_ids[$k + 1] = $fav_channel_ids[$k];
                $fav_channel_ids[$k] = $t;
            }
        }

        $this->set_fav_channel_ids($plugin_cookies, $fav_channel_ids);

        return ActionFactory::invalidate_folders(
            array(TvFavoritesScreen::get_media_url_str()));
    }

    public function is_favorite_category_id($category_id, &$plugin_cookies)
    {
        if (!$this->favorites_supported)
            return false;

        $fav_category_ids = $this->get_fav_category_ids($plugin_cookies);

        $k = array_search($category_id, $fav_category_ids);

        return $k !== false;
    }

    public function change_tv_favorites_categories($fav_op_type, $category_id, &$plugin_cookies)
    {
        $fav_category_ids = $this->get_fav_category_ids($plugin_cookies);

        if ($fav_op_type === PLUGIN_FAVORITES_OP_ADD)
        {
            array_push($fav_category_ids, $category_id);
        }
        else if ($fav_op_type === PLUGIN_FAVORITES_OP_REMOVE)
        {
            $k = array_search($category_id, $fav_category_ids);

            if ($k !== false)
                unset ($fav_category_ids[$k]);
        }
        else if ($fav_op_type === PLUGIN_FAVORITES_OP_MOVE_UP)
        {
            $k = array_search($category_id, $fav_category_ids);

            if ($k !== false && $k !== 0)
            {
                $t = $fav_category_ids[$k - 1];
                $fav_category_ids[$k - 1] = $fav_category_ids[$k];
                $fav_category_ids[$k] = $t;
            }
        }
        else if ($fav_op_type === PLUGIN_FAVORITES_OP_MOVE_DOWN)
        {
            $k = array_search($category_id, $fav_category_ids);

            if ($k !== false && $k !== count($fav_category_ids) - 1)
            {
                $t = $fav_category_ids[$k + 1];
                $fav_category_ids[$k + 1] = $fav_category_ids[$k];
                $fav_category_ids[$k] = $t;
            }
        }

        $this->set_fav_category_ids($plugin_cookies, $fav_category_ids);

        return ActionFactory::invalidate_folders(
            array(TvFavoritesScreen::get_media_url_str()));
    }
    ///////////////////////////////////////////////////////////////////////

    public function favorites_nonempty(&$plugin_cookies)
    {
        $channels_nonempty = isset($plugin_cookies->favorite_channels) &&
            '' != $plugin_cookies->favorite_channels;
        $categories_nonempty = isset($plugin_cookies->favorite_categories) &&
            '' != $plugin_cookies->favorite_categories;

        return $channels_nonempty || $categories_nonempty;
    }

    private static function get_ids_from_comma_split_str($str)
    {
        $arr = preg_split('/,/', $str);
        $ids = array();
        foreach ($arr as $id)
        {
            if ($id != '')
                $ids[] = $id;
        }
        return $ids;
    }

    public function get_fav_channel_ids(&$plugin_cookies)
    {
        if (!isset($plugin_cookies->{'favorite_channels'}))
            return array();
        return self::get_ids_from_comma_split_str($plugin_cookies->{'favorite_channels'});
    }

    public function get_fav_category_ids(&$plugin_cookies)
    {
        if (!isset($plugin_cookies->{'favorite_categories'}))
            return array();
        return self::get_ids_from_comma_split_str($plugin_cookies->{'favorite_categories'});
    }

    ///////////////////////////////////////////////////////////////////////

    public function set_fav_channel_ids(&$plugin_cookies, &$ids)
    {
        $plugin_cookies->{'favorite_channels'} = join(',', $ids);
    }

    public function set_fav_category_ids(&$plugin_cookies, &$ids)
    {
        $plugin_cookies->{'favorite_categories'} = join(',', $ids);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_archive(MediaURL $media_url)
    {
        return null;
    }
}

///////////////////////////////////////////////////////////////////////////
?>
