<?php

class Sticker
{
    private function __construct()
    { }

    public static function sticker($items, $above_selection=false, $auto_scale=false)
    {
        if (!$items)
            return null;
        return array('items' => $items,
            'above_selection' => $above_selection,
            'auto_scale' => $auto_scale);
    }

    public static function item($geom, $comp)
    {
        return array('geom' => $geom, 'comp' => $comp);
    }

    public static function geom($x, $y, $halign='right', $valign='top')
    {
        return array('x' => $x, 'y' => $y,
            'halign' => $halign, 'valign' => $valign);
    }

    public static function icon_arr($url, $icon_w=-1, $icon_h=-1)
    {
        $arr = array('type' => 'icon', 'url' => $url);
        if ($icon_w > 0)
            $arr['width'] = $icon_w;
        if ($icon_h > 0)
            $arr['height'] = $icon_h;
        return $arr;
    }

    public static function gap_arr($width)
    {
        return array('type' => 'gap', 'width' => $width);
    }

    public static function icon($url, $icon_w=-1, $icon_h=-1)
    {
        $arr = self::icon_arr($url, $icon_w, $icon_h);
        return array('items' => array($arr));
    }

    public static function rect($color, $w, $h)
    {
        $arr = array('type' => 'icon', 'color' => $color,
            'width' => $w, 'height' => $h);
        return array('items' => array($arr));
    }

    public static function text($text, $color=null, $size=null)
    {
        $arr = array('type' => 'text', 'text' => $text);
        if (isset($color))
            $arr['color'] = $color;
        if ($size)
            $arr['size'] = $size;
        return array('items' => array($arr));
    }
}

?>
