<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/abstract_rows_screen.php';
require_once 'lib/rows_factory.php';
require_once 'lib/gcomps_factory.php';
require_once 'lib/gcomp_geom.php';

///////////////////////////////////////////////////////////////////////////

class DummyEpfScreen extends AbstractRowsScreen
{
    const ID = 'dummy_epf';

    public static function get_media_url_str($no_internet)
    {
        $arr['no_internet'] = $no_internet;
        return MediaURL::encode($arr);
    }

    ///////////////////////////////////////////////////////////////////////

    public function __construct()
    {
        parent::__construct(self::ID);
    }

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        $actions[GUI_EVENT_KEY_ENTER] = $this->custom_action('enter');
        return $actions;
    }

    public function get_rows_pane(MediaURL $media_url, &$plugin_cookies)
    {
        $defs = array();

        $caption = null;
        $image_url = null;

        $caption = $media_url->no_internet ?
            T::g("epf_no_internet") : T::g("epf_loading");

        $rows[] = RowsFactory::vgap_row(50);

        $defs[] = GCompsFactory::label_v2(
            GCompGeom::place_center(-1, -1, 0, 0), null,
            $caption, 1, "#FFAFAFA0", 60);

        $rows[] = RowsFactory::gcomps_row("single_row",
            $defs, null, 1920, 500);
        return RowsFactory::pane($rows);
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        if (!isset($user_input->control_id) || $user_input->control_id != 'timer')
        {
            hd_print('DummyEpf screen: handle_user_input:');
            foreach ($user_input as $key => $value)
                hd_print("  $key => $value");
        }

        $control_id = isset($user_input->control_id) ?
            $user_input->control_id : "none";

        return null;
    }

    public function get_folder_view_for_epf($no_internet, &$plugin_cookies)
    {
        $media_url_str = self::get_media_url_str($no_internet);
        $media_url = MediaURL::decode($media_url_str);
        return $this->get_folder_view($media_url, $plugin_cookies);
    }
}
?>
