<?php
///////////////////////////////////////////////////////////////////////////

class ActionFactory
{
    public static function open_folder($media_url = null, $caption = null,
        $id = null, $post_action = null)
    {
        $data = array(
            PluginOpenFolderActionData::media_url => $media_url,
            PluginOpenFolderActionData::caption => $caption,
        );
        if (defined('PluginOpenFolderActionData::id'))
        {
            $data[PluginOpenFolderActionData::id] = $id;
            $data[PluginOpenFolderActionData::post_action] = $post_action;
        }
        return array
        (
            GuiAction::handler_string_id => PLUGIN_OPEN_FOLDER_ACTION_ID,
            GuiAction::data => $data,
        );
    }

    public static function tv_play($media_url=null,
        $initial_channel_id=null, $initial_group_id=null, $initial_is_favorite=null)
    {
        $arr = array(
            GuiAction::handler_string_id => PLUGIN_TV_PLAY_ACTION_ID,
        );

        $data = array();
        if ($initial_channel_id)
            $data[PluginTvPlayActionData::initial_channel_id] = $initial_channel_id;
        if ($initial_group_id)
            $data[PluginTvPlayActionData::initial_group_id] = $initial_group_id;
        if ($initial_is_favorite)
            $data[PluginTvPlayActionData::initial_is_favorite] = $initial_is_favorite;
        if ($data)
            $arr[GuiAction::data] = $data;

        if ($media_url)
        {
            $arr[GuiAction::params] = array(
                'selected_media_url' => $media_url);
        }
        return $arr;
    }

    public static function vod_play()
    {
        return array
        (
            GuiAction::handler_string_id => PLUGIN_VOD_PLAY_ACTION_ID,
        );
    }

    public static function vod_play_ext($vod_info = null)
    {
        return array
        (
            GuiAction::handler_string_id => PLUGIN_VOD_PLAY_ACTION_ID,
            GuiAction::data =>
                array
                (
                    PluginVodPlayActionData::vod_info => $vod_info,
                ),
        );
    }

    public static function show_error($fatal, $title,
        $msg_lines=null, $stop_playback=false, $retry_delay_ms=0)
    {
        if ($fatal)
            hd_print("Plugin fatal error.");

        $data = array(
            PluginShowErrorActionData::fatal => $fatal,
            PluginShowErrorActionData::title => $title,
            PluginShowErrorActionData::msg_lines => $msg_lines,
        );
        if (defined('PluginShowErrorActionData::stop_playback'))
        {
            $data[PluginShowErrorActionData::stop_playback] = $stop_playback;
            $data[PluginShowErrorActionData::retry_delay_ms] = $retry_delay_ms;
        }
        return array
        (
            GuiAction::handler_string_id => PLUGIN_SHOW_ERROR_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data => $data,
            GuiAction::params => null,
        );
    }

    public static function fatal_error()
    {
        return self::show_error(true, null);
    }

    public static function show_dialog($title, $defs,
        $close_by_return = false, $preferred_width = 0,
        $attrs = array())
    {
        $initial_sel_ndx = isset($attrs['initial_sel_ndx']) ?
            $attrs['initial_sel_ndx'] : -1;
        $actions = isset($attrs['actions']) ? $attrs['actions'] : null;
        $timer = isset($attrs['timer']) ? $attrs['timer'] : null;
        $min_item_title_width = isset($attrs['min_item_title_width']) ?
            $attrs['min_item_title_width'] : 0;
        $max_height = isset($attrs['max_height']) ?
            $attrs['max_height'] : 0;
        $params = isset($attrs['params']) ? $attrs['params'] : null;

        $data = array(
            ShowDialogActionData::title => $title,
            ShowDialogActionData::defs => $defs,
            ShowDialogActionData::close_by_return => $close_by_return,
            ShowDialogActionData::preferred_width => $preferred_width,
            ShowDialogActionData::min_item_title_width => $min_item_title_width,
            ShowDialogActionData::initial_sel_ndx => $initial_sel_ndx,
            ShowDialogActionData::actions => $actions,
            ShowDialogActionData::timer => $timer,
            ShowDialogActionData::params => $params,
        );
        if (defined('ShowDialogActionData::max_height'))
            $data[ShowDialogActionData::max_height] = $max_height;
        return array
        (
            GuiAction::handler_string_id => SHOW_DIALOG_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data => $data,
            GuiAction::params => null,
        );
    }

    public static function close_dialog_and_run($post_action)
    {
        return array
        (
            GuiAction::handler_string_id => CLOSE_DIALOG_AND_RUN_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data =>
                array
                (
                    CloseDialogAndRunActionData::post_action => $post_action,
                ),
            GuiAction::params => null,
        );
    }

    public static function close_dialog()
    {
        return self::close_dialog_and_run(null);
    }

    public static function close_and_run($post_action=null)
    {
        return array
        (
            GuiAction::handler_string_id => CLOSE_AND_RUN_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data =>
                array
                (
                    CloseAndRunActionData::post_action => $post_action,
                ),
            GuiAction::params => null,
        );
    }

    public static function show_title_dialog($title,
        $post_action = null, $attrs=array())
    {
        $defs = array();

//        ControlFactory::add_vgap($defs, 50);

        ControlFactory::add_custom_close_dialog_and_apply_button($defs,
            'ok', 'OK', 300, $post_action);

        return self::show_dialog($title, $defs, false, 0, $attrs);
    }

    public static function show_message_dialog($title, $messages, $post_action = null)
    {
        $defs = array();

        foreach ($messages as $msg)
        {
            ControlFactory::add_label($defs, null, $msg);
            ControlFactory::add_vgap($defs, -15);
        }

        ControlFactory::add_vgap($defs, 30);
        ControlFactory::add_custom_close_dialog_and_apply_button($defs,
            'ok', 'OK', 300, $post_action);

        return self::show_dialog($title, $defs);
    }

    public static function show_yes_no_dialog($title, $yes_action,
        $close_by_return = false)
    {
        $defs = array();

        ControlFactory::add_custom_button($defs,
            self::close_dialog_and_run($yes_action),
            'yes', null, T::key_global('yes_no_choice_yes'), 300);

        ControlFactory::add_close_dialog_button($defs,
            T::key_global('yes_no_choice_no'), 300);

        return self::show_dialog($title, $defs, $close_by_return);
    }

    public static function status($status)
    {
        return array
        (
            GuiAction::handler_string_id => STATUS_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data =>
                array
                (
                    StatusActionData::status => $status,
                ),
            GuiAction::params => null,
        );
    }

    public static function invalidate_folders($media_urls,
        $post_action = null, $all_except = false)
    {
        $data = array(
            PluginInvalidateFoldersActionData::media_urls => $media_urls,
            PluginInvalidateFoldersActionData::post_action => $post_action,
        );

        if (defined('PluginInvalidateFoldersActionData::all_except'))
            $data[PluginInvalidateFoldersActionData::all_except] = $all_except;
        else if ($all_except)
            return $post_action;

        return array
        (
            GuiAction::handler_string_id => PLUGIN_INVALIDATE_FOLDERS_ACTION_ID,
            GuiAction::data => $data,
        );
    }

    public static function invalidate_all_folders($post_action = null,
        $except_media_urls = null)
    {
        return self::invalidate_folders($except_media_urls, $post_action, true);
    }

    public static function show_popup_menu($menu_items, $sel_ndx = 0)
    {
        return array
        (
            GuiAction::handler_string_id => SHOW_POPUP_MENU_ACTION_ID,
            GuiAction::data =>
                array
                (
                    ShowPopupMenuActionData::menu_items => $menu_items,
                    ShowPopupMenuActionData::selected_menu_item_index => $sel_ndx,
                ),
        );
    }

    public static function get_menu_item($caption, $action,
        $icon_url=null)
    {
        $arr = array(
            GuiMenuItemDef::caption => $caption,
            GuiMenuItemDef::action => $action);
        if ($icon_url)
            $arr[GuiMenuItemDef::icon_url] = $icon_url;
        return $arr;
    }

    public static function update_regular_folder($range,
        $need_refresh = false, $sel_ndx = -1)
    {
        return array
        (
            GuiAction::handler_string_id => PLUGIN_UPDATE_FOLDER_ACTION_ID,
            GuiAction::data =>
                array
                (
                    PluginUpdateFolderActionData::range => $range,
                    PluginUpdateFolderActionData::need_refresh => $need_refresh,
                    PluginUpdateFolderActionData::sel_ndx => intval($sel_ndx),
                ),
        );
    }

    public static function reset_controls($defs, $post_action = null, $initial_sel_ndx = -1)
    {
        return array
        (
             GuiAction::handler_string_id => RESET_CONTROLS_ACTION_ID,
             GuiAction::data =>
             array
             (
                ResetControlsActionData::defs => $defs,
                ResetControlsActionData::initial_sel_ndx => $initial_sel_ndx,
                ResetControlsActionData::post_action => $post_action,
             ),
        );
    }

    public static function clear_archive_cache($archive_id=null, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => PLUGIN_CLEAR_ARCHIVE_CACHE_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginClearArchiveCacheActionData::archive_id => $archive_id,
                PluginClearArchiveCacheActionData::post_action => $post_action,
             ),
        );
    }

    public static function launch_media_url_ext($url, $caption=null,
        $post_action=null, $start_index=-1, $params=null)
    {
        $data = array(
            LaunchMediaUrlActionData::url => $url,
            LaunchMediaUrlActionData::post_action => $post_action,
        );
        if (defined('LaunchMediaUrlActionData::caption'))
            $data[LaunchMediaUrlActionData::caption] = $caption;
        if (defined('LaunchMediaUrlActionData::start_index'))
            $data[LaunchMediaUrlActionData::start_index] = $start_index;
        if (defined('LaunchMediaUrlActionData::params'))
            $data[LaunchMediaUrlActionData::params] = $params;
        return array
        (
             GuiAction::handler_string_id => LAUNCH_MEDIA_URL_ACTION_ID,
             GuiAction::data => $data,
        );
    }

    public static function launch_media_url($url, $post_action=null)
    {
        return self::launch_media_url_ext($url, null, $post_action);
    }

    public static function show_main_screen($post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => SHOW_MAIN_SCREEN_ACTION_ID,
             GuiAction::data =>
             array
             (
                ShowMainScreenActionData::post_action => $post_action,
             ),
        );
    }

    public static function handle_user_input($params,
        $timeout_ms=null, $show_dialog_delay_ms=null)
    {
        $data = null;
        if ((isset($timeout_ms) || isset($show_dialog_delay_ms)) &&
            defined('PluginHandleUserInputActionData::operation_timeout'))
        {
            $data = array();
            if (isset($timeout_ms))
            {
                $data[PluginHandleUserInputActionData::operation_timeout] =
                    intval($timeout_ms);
            }
            if (isset($show_dialog_delay_ms))
            {
                $data[PluginHandleUserInputActionData::show_dialog_delay] =
                    intval($show_dialog_delay_ms);
            }
        }

        return array
        (
            GuiAction::handler_string_id => PLUGIN_HANDLE_USER_INPUT_ACTION_ID,
            GuiAction::caption => null,
            GuiAction::data => $data,
            GuiAction::params => $params,
        );
    }

    public static function change_behaviour($actions, $timer=null, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => CHANGE_BEHAVIOUR_ACTION_ID,
             GuiAction::data =>
             array
             (
                ChangeBehaviourActionData::actions => $actions,
                ChangeBehaviourActionData::timer => $timer,
                ChangeBehaviourActionData::post_action => $post_action,
             ),
        );
    }

    public static function change_settings($settings, $reboot, $restart_gui,
        $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => CHANGE_SETTINGS_ACTION_ID,
             GuiAction::data =>
             array
             (
                ChangeSettingsActionData::settings => $settings,
                ChangeSettingsActionData::reboot => $reboot,
                ChangeSettingsActionData::restart_gui => $restart_gui,
                ChangeSettingsActionData::post_action => $post_action,
             ),
        );
    }

    public static function update_rows_menu($post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => PLUGIN_UPDATE_ROWS_MENU_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginUpdateRowsMenuActionData::post_action => $post_action,
             ),
        );
    }

    public static function update_epf_mapping(
        $epf_id, $mapped_plugin_name, $sync_epfs, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => PLUGIN_UPDATE_EPF_MAPPING_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginUpdateEpfMappingActionData::epf_id => $epf_id,
                PluginUpdateEpfMappingActionData::mapped_plugin_name => $mapped_plugin_name,
                PluginUpdateEpfMappingActionData::sync_epfs => $sync_epfs,
                PluginUpdateEpfMappingActionData::post_action => $post_action,
             ),
        );
    }

    public static function reread_all_epfs($sync_epfs, $post_action=null)
    {
        return self::update_epf_mapping(null, null, $sync_epfs, $post_action);
    }

    public static function add_menu_items($menu_items)
    {
        return array
        (
            GuiAction::handler_string_id => ADD_MENU_ITEMS_ACTION_ID,
            GuiAction::data =>
                array
                (
                    AddMenuItemsActionData::menu_items => $menu_items,
                ),
        );
    }

    public static function timer($delay_ms, $reset_on_keypress=false)
    {
        $arr = array(GuiTimerDef::delay_ms => $delay_ms);
        if ($reset_on_keypress && defined('GuiTimerDef::reset_on_keypress'))
            $arr[GuiTimerDef::reset_on_keypress] = true;
        return $arr;
    }

    public static function change_gcomps($sel_state,
        $change_defs, $interrupt_disabled=false, $num_steps=0,
        $small_state_text=null,
        $post_action=null, $ui_state=null)
    {
        return array(
            GuiAction::handler_string_id => CHANGE_GCOMPS_ACTION_ID,
            GuiAction::data => array(
                ChangeGCompsActionData::change_defs => $change_defs,
                ChangeGCompsActionData::interrupt_disabled => $interrupt_disabled,
                ChangeGCompsActionData::num_steps => $num_steps,
                ChangeGCompsActionData::sel_state => $sel_state,
                ChangeGCompsActionData::small_state_text => $small_state_text,
                ChangeGCompsActionData::ui_state => $ui_state,
                ChangeGCompsActionData::post_action => $post_action,
            ));
    }

    public static function update_rows_info(
        $folder_key, $item_id, $info_defs,
        $bg_url=null, $nl_bg_url=null, $mask_url=null,
        $playback_urls=null, $post_action=null)
    {
        $info = array(
            PluginRowsInfo::folder_key => $folder_key,
            PluginRowsInfo::item_id => $item_id,
            PluginRowsInfo::info_defs => $info_defs,
            PluginRowsInfo::bg_url => $bg_url,
            PluginRowsInfo::nl_bg_url => $nl_bg_url,
            PluginRowsInfo::mask_url => $mask_url,
            PluginRowsInfo::playback_urls => $playback_urls,
        );
        return array
        (
             GuiAction::handler_string_id => PLUGIN_UPDATE_ROWS_INFO_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginUpdateRowsInfoActionData::info => $info,
                PluginUpdateRowsInfoActionData::post_action => $post_action,
             ),
        );
    }

    public static function clear_rows_info_cache($post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => PLUGIN_UPDATE_ROWS_INFO_ACTION_ID,
             GuiAction::data =>
             array
             (
                PluginUpdateRowsInfoActionData::clear_cache => true,
                PluginUpdateRowsInfoActionData::post_action => $post_action,
             ),
        );
    }

    public static function run_builtin($builtin_action_id, $params=null,
        $post_action=null, $error_action=null)
    {
        return array
        (
            GuiAction::handler_string_id => RUN_BUILTIN_ACTION_ID,
            GuiAction::data =>
                array
                (
                    RunBuiltinActionData::builtin_action_id => $builtin_action_id,
                    RunBuiltinActionData::params => $params,
                    RunBuiltinActionData::post_action => $post_action,
                    RunBuiltinActionData::error_action => $error_action,
                ),
        );
    }

    public static function wget($url, $post_data=null, $curl_opts=null,
        $id=null, $target_path=null, $target_cmd=null,
        $result_key_prefix=null, $post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => WGET_ACTION_ID,
             GuiAction::data =>
             array
             (
                WgetActionData::id => $id,
                WgetActionData::url => $url,
                WgetActionData::post_data => $post_data,
                WgetActionData::curl_opts => $curl_opts,
                WgetActionData::target_path => $target_path,
                WgetActionData::target_cmd => $target_cmd,
                WgetActionData::result_key_prefix => $result_key_prefix,
                WgetActionData::post_action => $post_action,
             ),
        );
    }

    public static function add_gui_item(&$items,
        $id, $caption, $icon_url=null, $group_id=null)
    {
        $item = array(GuiItem::id => $id, GuiItem::caption => $caption);
        if ($icon_url)
            $item[GuiItem::icon_url] = $icon_url;
        if (isset($group_id))
            $item[GuiItem::group_id] = $group_id;
        $items[] = $item;
    }

    public static function edit_list_config(
        $config_id, $title, $all_items, $checked_ids, $groups,
        $options, $post_action)
    {
        if (!defined('EditListConfigActionData::config_id'))
            return null;

        $arr = array(
            EditListConfigActionData::config_id => $config_id,
            EditListConfigActionData::title => $title,
            EditListConfigActionData::all_items => $all_items,
            EditListConfigActionData::post_action => $post_action,
        );
        if ($checked_ids)
            $arr[EditListConfigActionData::checked_ids] = $checked_ids;
        if ($groups)
            $arr[EditListConfigActionData::groups] = $groups;
        if ($options)
            $arr[EditListConfigActionData::options] = $options;
        return array
        (
             GuiAction::handler_string_id => EDIT_LIST_CONFIG_ACTION_ID,
             GuiAction::data => $arr,
        );
    }

    ///////////////////////////////////////////////////////////////////////

    public static function set_action_param(&$action, $key, $value)
    {
        if (!isset($action['params']))
            $action['params'] = array($key => $value);
        else
            $action['params'][$key] = $value;
    }

    ///////////////////////////////////////////////////////////////////////

    public static function set_user_input_value(
        &$action, $key1, $key2, $value)
    {
        if (!$action)
            return;
        while (
            $action[GuiAction::handler_string_id] !=
                PLUGIN_HANDLE_USER_INPUT_ACTION_ID &&
            isset($action[GuiAction::data]) &&
            isset($action[GuiAction::data]['post_action']))
        {
            $action = &$action[GuiAction::data]['post_action'];
        }
        if ($action[GuiAction::handler_string_id] !=
            PLUGIN_HANDLE_USER_INPUT_ACTION_ID)
        {
            hd_print("Warning: not handle_user_input action; ignored");
            return;
        }
        if (!isset($action[$key1]))
            $action[$key1] = array();
        $action[$key1][$key2] = $value;
    }

    public static function set_user_input_timeout(&$action, $value)
    {
        self::set_user_input_value($action, GuiAction::data,
            PluginHandleUserInputActionData::operation_timeout, $value);
    }

    public static function set_user_input_dialog_delay(&$action, $value)
    {
        self::set_user_input_value($action, GuiAction::data,
            PluginHandleUserInputActionData::show_dialog_delay, $value);
    }

    public static function action_from_user_input($user_input,
        $add_params=null, $rem_keys=null)
    {
        $arr = array();
        foreach ($user_input as $key => $val)
            $arr[$key] = $val;
        if ($add_params) {
            foreach ($add_params as $key => $val)
                $arr[$key] = $val;
        }
        if ($rem_keys) {
            foreach ($rem_keys as $key)
                unset($arr[$key]);
        }
        $a = self::handle_user_input($arr);
        $a[GuiAction::plugin_name] =
            DuneSystem::$properties['plugin_name'];
        return $a;
    }

    public static function change_parental_code($post_action=null)
    {
        return array
        (
             GuiAction::handler_string_id => CHANGE_PARENTAL_CODE_ACTION_ID,
             GuiAction::data =>
             array
             (
                 CheckSystemStorageActionData::post_action => $post_action,
             ),
        );
    }
}

///////////////////////////////////////////////////////////////////////////
?>
