<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/rows_screen.php';

abstract class AbstractRowsScreen
    implements RowsScreen
{
    private $id;

    ///////////////////////////////////////////////////////////////////////

    protected $cur_sel_state = null;

    protected function __construct($id)
    {
        $this->id = $id;

        UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_cur_sel_state_str()
    {
        /*
        return isset($this->cur_sel_state) ?
            json_encode($this->cur_sel_state) : null;
        */
        return $this->cur_sel_state;
    }

    public function set_cur_sel_state_str($sel_state_str)
    {
        /*
        $this->cur_sel_state = isset($sel_state_str) ?
            json_decode($sel_state_str) : null;
            */
        $this->cur_sel_state = $sel_state_str;
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_handler_id()
    { return 'rows_' . $this->id; }

    public function get_id()
    { return $this->id; }

    public function get_category()
    { return self::DEFAULT_CATEGORY; }

    ///////////////////////////////////////////////////////////////////////

    public function get_timer(MediaURL $media_url, &$plugin_cookies)
    {
        return null;
    }

    public function invalidate()
    { }

    public function get_folder_type()
    { return null; }

    ///////////////////////////////////////////////////////////////////////

    public function get_folder_view_v2(MediaURL $media_url,
        $sel_state, &$plugin_cookies)
    {
        $this->set_cur_sel_state_str($sel_state);

        $pane = $this->get_rows_pane($media_url, $plugin_cookies);
        $actions = $this->get_action_map($media_url, $plugin_cookies);
        $timer = $this->get_timer($media_url, $plugin_cookies);

        $sel_state = $this->get_cur_sel_state_str();

        $folder_view = array
        (
            PluginRowsFolderView::pane      => $pane,
            PluginRowsFolderView::sel_state => $sel_state,
            PluginRowsFolderView::actions   => $actions,
            PluginRowsFolderView::timer     => $timer,
        );

        return array
        (
            PluginFolderView::multiple_views_supported  => false,
            PluginFolderView::archive                   => null,
            PluginFolderView::folder_type               => $this->get_folder_type(),
            PluginFolderView::view_kind                 => PLUGIN_FOLDER_VIEW_ROWS,
            PluginFolderView::data                      => $folder_view,
        );
    }

    public function get_folder_view(MediaURL $media_url, &$plugin_cookies)
    {
        return $this->get_folder_view_v2($media_url, null, $plugin_cookies);
    }

    protected function prepare_handle_user_input(&$user_input)
    {
        $sel_state = isset($user_input->parent_sel_state) ?
            $user_input->parent_sel_state : null;
        $this->set_cur_sel_state_str($sel_state);
    }

    protected function custom_action($control_id, $params=null)
    {
        return UserInputHandlerRegistry::create_action($this,
            $control_id, $params);
    }

/*
    protected function change_action($op)
    {
        return $this->custom_action('change', array('op' => $op));
    }
*/
}

///////////////////////////////////////////////////////////////////////////
?>
