<?php

class AbstractEpfsHandler
{
    const EPFS_BASE = '/flashdata/plugins_epfs/';

    private static $plugin_name = null;
    private static $dir_path = null;
    private static $base_tmp_path = null;
    private static $tmp_epfs_path = null;
    private static $epfs_path = null;

    public static function initialize($plugin_name=null)
    {
        self::$plugin_name = $plugin_name ? $plugin_name :
            DuneSystem::$properties['plugin_name'];
        self::$dir_path = self::EPFS_BASE . self::$plugin_name;
        self::$base_tmp_path = "/tmp/plugins/" . self::$plugin_name;
        self::$tmp_epfs_path = self::$base_tmp_path . "/epfs";
        self::$epfs_path = "/flashdata/plugins_epfs/" . self::$plugin_name;
    }

    public static function get_plugin_name()
    {
        return self::$plugin_name;
    }

    public static function warmed_up_path()
    {
        return self::$base_tmp_path . "/epfs_warmed_up";
    }

    public static function async_worker_warmed_up_path()
    {
        return self::$base_tmp_path . "/async_worker_warmed_up";
    }

    public static function get_epfs_changed_path()
    {
        return self::$base_tmp_path . "/update_epfs_if_needed_flag";
    }

    protected static function get_tag_path($name='all')
    {
        return self::$dir_path . "/tag_$name";
    }

    protected static function read_tag($name='all')
    {
        $path = self::get_tag_path($name);
        return is_file($path) ? file_get_contents($path) : "";
    }

    protected static function write_tag($value, $name='all')
    {
        $path = self::get_tag_path($name);
        file_put_contents($path, $value);
    }

    protected static function get_epfs_ts_path($id="tv")
    {
        return self::$dir_path . "/${id}_timestamp";
    }

    protected static function read_epfs_ts($id="tv")
    {
        $path = self::get_epfs_ts_path($id);
        return is_file($path) ? file_get_contents($path) : "";
    }

    protected static function write_epfs_ts($ts, $id="tv")
    {
        if (!$ts)
            $ts = self::make_monotonic_ts();
        $path = self::get_epfs_ts_path($id);
        file_put_contents($path, $ts);
    }

    public static function make_monotonic_ts()
    {
        $arr = gettimeofday();
        return sprintf("%010d.%06d", $arr['sec'], $arr['usec']);
    }

    public static function read_data_ts($path)
    {
        return is_file($path) ? file_get_contents($path) : "";
    }

    public static function cmp_ts($ts1, $ts2)
    {
        return strcmp($ts1, $ts2);
    }

    public static function max_ts($ts1, $ts2)
    {
        return self::cmp_ts($ts1, $ts2) < 0 ? $ts2 : $ts1;
    }

    public static function write_data_ts($path, $ts=null)
    {
        if (!isset($ts))
            $ts = self::make_monotonic_ts();
        file_put_contents($path, $ts);
        return $ts;
    }

    protected static function get_epf_path($epf_id)
    {
        return self::$tmp_epfs_path . "/$epf_id.json";
    }

    protected static function get_no_internet_epf_path($epf_id)
    {
        return self::$dir_path . "/$epf_id.no_internet.json";
    }

    ///////////////////////////////////////////////////////////////////////

    private static function do_write_epf_data($path, $data, $log_str)
    {
        $tmp_path = "$path.tmp";
        $len = strlen($data);
hd_print("XXX DEBUG ZZZ write epf for $log_str ($len bytes)");
        if (false !== file_put_contents($tmp_path, $data))
        {
            if (!rename($tmp_path, $path))
            {
                hd_print("Failed to tmp_rename($path)");
                unlink($tmp_path);
            }
        }
        else
            hd_print("Failed to write file: $tmp_path");
    }

    private static function write_epf_data($epf_id, $data)
    {
        $path = self::get_epf_path($epf_id);
        $log_str = $epf_id;
        self::do_write_epf_data($path, $data, $log_str);
    }

    protected static function write_no_internet_epf($epf_id, $folder_view)
    {
        $path = self::get_no_internet_epf_path($epf_id);
        $data = json_encode($folder_view);
        HD::write_to_file_using_tmp_if_changed($path, $data);
    }

    protected static function write_dummy_epf($epf_id)
    {
        self::write_epf_data($epf_id, "");
    }

    protected static function write_epf($epf_id, $folder_view)
    {
        if (!$folder_view)
        {
hd_print("XXX DEBUG ZZZ ERROR failed to create folder_view for $epf_id");
            return;
        }

        $data = json_encode($folder_view);
        self::write_epf_data($epf_id, $data);
    }

    protected static function write_rmc($obj)
    {
        $path = self::$epfs_path . "/rows_menu_config.json";
        $data = json_encode($obj);
        HD::write_to_file_using_tmp_if_changed($path, $data);
    }
}

?>
