<?php

class ConfigUtils
{
    public static function partial_load_properties_file($path, &$props)
    {
        if (!is_file($path))
            return $props;

        $lines = file($path);
        foreach ($lines as $line)
        {
            $pos = strpos($line, "=");
            if ($pos === false)
                continue;

            $key = trim(substr($line, 0, $pos));
            if (isset($props->$key))
                $props->$key = trim(substr($line, $pos + 1));
        }
        return $props;
    }

    public static function load_firmware_features()
    {
        $path = "/tmp/firmware_features.txt";

        $ffset = array();
        foreach (HD::readlines($path) as $ff)
            $ffset[$ff] = 1;
        return $ffset;
    }
}

?>
