<?php
/**
 * The MIT License (MIT)
 *
 * @Author: sharky72 (https://github.com/KocourKuba)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

require_once 'lib/abstract_controls_screen.php';
require_once 'lib/user_input_handler.php';

///////////////////////////////////////////////////////////////////////////

class Starnet_Setup_Category_Screen extends Abstract_Controls_Screen
{
    const ID = 'category_setup';

    const ACTION_SHOW_ALL = 'show_all_channels';
    const ACTION_SHOW_FAVORITES = 'show_favorites';
    const ACTION_SHOW_HISTORY = 'show_history';
    const ACTION_SHOW_VOD = 'show_vod';
    const ACTION_SHOW_CHANGED_CHANNELS = 'show_changed_channels';
    const ACTION_SHOW_VOD_ICON = 'show_vod_icon';
    const ACTION_SHOW_ADULT = 'show_adult';

    ///////////////////////////////////////////////////////////////////////

    protected $force_parent_reload = false;

    /**
     * @inheritDoc
     */
    public function get_control_defs(MediaURL $media_url, &$plugin_cookies)
    {
        return $this->do_get_control_defs();
    }

    /**
     * interface dialog defs
     * @return array
     */
    protected function do_get_control_defs()
    {
        hd_debug_print(null, true);

        $defs = array();
        //////////////////////////////////////
        // Plugin name
        $this->plugin->create_setup_header($defs);

        //////////////////////////////////////
        // picon settings

        $picons_ops[PLAYLIST_PICONS] = TR::t('playlist_picons');
        $picons_ops[XMLTV_PICONS] = TR::t('xmltv_picons');
        $picons_ops[COMBINED_PICONS] = TR::t('combined_picons');
        $picons_idx = $this->plugin->get_setting(PARAM_USE_PICONS, PLAYLIST_PICONS);
        Control_Factory::add_combobox($defs, $this, PARAM_USE_PICONS, TR::t('setup_channels_picons_source'),
            $picons_idx, $picons_ops, Control_Factory::SCR_CONTROLS_WIDTH, $params, true);
/*
        //////////////////////////////////////
        // Delayed picons indexing
        if (defined('PluginUpdateEpgActionData::ext_epg_enabled') && $picons_idx !== PLAYLIST_PICONS) {
            $delay_load = $this->plugin->get_setting(PARAM_PICONS_DELAY_LOAD, SwitchOnOff::off);
            Control_Factory::add_image_button($defs, $this, null,
                PARAM_PICONS_DELAY_LOAD, TR::t('setup_channels_delay_picons_load'), SwitchOnOff::translate($delay_load),
                SwitchOnOff::to_image($delay_load), Control_Factory::CONTROLS_WIDTH);
        }
*/

        //////////////////////////////////////
        // show all channels category
        $show_all = $this->plugin->get_setting(PARAM_SHOW_ALL, SwitchOnOff::on);
        hd_debug_print("All channels group: $show_all", true);
        Control_Factory::add_image_button($defs, $this, PARAM_SHOW_ALL,
            TR::t('setup_show_all_channels'), SwitchOnOff::translate($show_all), SwitchOnOff::to_image($show_all));

        //////////////////////////////////////
        // show favorites category
        $show_fav = $this->plugin->get_setting(PARAM_SHOW_FAVORITES, SwitchOnOff::on);
        hd_debug_print("Favorites group: $show_fav", true);
        Control_Factory::add_image_button($defs, $this, PARAM_SHOW_FAVORITES,
            TR::t('setup_show_favorites'), SwitchOnOff::translate($show_fav), SwitchOnOff::to_image($show_fav));

        //////////////////////////////////////
        // show history category
        $show_history = $this->plugin->get_setting(PARAM_SHOW_HISTORY, SwitchOnOff::on);
        hd_debug_print("History group: $show_history", true);
        Control_Factory::add_image_button($defs, $this, PARAM_SHOW_HISTORY,
            TR::t('setup_show_history'), SwitchOnOff::translate($show_history), SwitchOnOff::to_image($show_history));

        //////////////////////////////////////
        // show changed channels category
        $show_changed = $this->plugin->get_setting(PARAM_SHOW_CHANGED_CHANNELS, SwitchOnOff::on);
        hd_debug_print("Changed group: $show_changed", true);
        Control_Factory::add_image_button($defs, $this, PARAM_SHOW_CHANGED_CHANNELS,
            TR::t('setup_show_changed_channels'), SwitchOnOff::translate($show_changed), SwitchOnOff::to_image($show_changed));

        //////////////////////////////////////
        // show VOD
        $show_mediateka = $this->plugin->get_setting(PARAM_SHOW_VOD, SwitchOnOff::on);
        hd_debug_print("VOD group: $show_mediateka", true);
        Control_Factory::add_image_button($defs, $this, PARAM_SHOW_VOD,
            TR::t('setup_show_vod'), SwitchOnOff::translate($show_mediateka), SwitchOnOff::to_image($show_mediateka));

        //////////////////////////////////////
        // show adult
        $show_adult = $this->plugin->get_setting(PARAM_SHOW_ADULT, SwitchOnOff::on);
        hd_debug_print("Adult group: $show_adult", true);
        Control_Factory::add_image_button($defs, $this, PARAM_SHOW_ADULT,
            TR::t('setup_show_adult'), SwitchOnOff::translate($show_adult), SwitchOnOff::to_image($show_adult));

        return $defs;
    }

    /**
     * @inheritDoc
     */
    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        $control_id = $user_input->control_id;
        $post_action = null;

        switch ($control_id) {
            case GUI_EVENT_KEY_TOP_MENU:
            case GUI_EVENT_KEY_RETURN:
                $reload = $this->force_parent_reload;
                $this->force_parent_reload = false;
                hd_debug_print("Force parent reload", true);
                $parent_media_url = MediaURL::decode($user_input->parent_media_url);
                $post_action = self::make_return_action($parent_media_url);

                if ($reload) {
                    return Action_Factory::invalidate_all_folders($plugin_cookies, null, $post_action);
                }
                return $post_action;

            case PARAM_SHOW_ALL:
            case PARAM_SHOW_FAVORITES:
            case PARAM_SHOW_HISTORY:
            case PARAM_SHOW_CHANGED_CHANNELS:
            case PARAM_SHOW_VOD:
            case PARAM_SHOW_ADULT:
            case PARAM_PICONS_DELAY_LOAD:
                $this->force_parent_reload = true;
                $this->plugin->toggle_setting($control_id);
                $this->plugin->update_ui_settings();
                break;

            case PARAM_USE_PICONS:
                $this->force_parent_reload = true;
                $active_sources = $this->plugin->get_selected_xmltv_ids();
                $val = $user_input->{$control_id};
                if (empty($active_sources) && $val !== PLAYLIST_PICONS) {
                    $post_action = Action_Factory::show_title_dialog(TR::t('err_error'), TR::t('err_no_xmltv_sources'));
                }

                $this->plugin->set_setting($user_input->control_id, $val);
                $this->plugin->update_ui_settings();
                break;
        }

        return Action_Factory::reset_controls($this->do_get_control_defs(), $post_action);
    }
}
