<?php
/**
 * The MIT License (MIT)
 *
 * @Author: sharky72 (https://github.com/KocourKuba)
 * Original code from DUNE HD
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

require_once 'abstract_regular_screen.php';

abstract class Abstract_Preloaded_Regular_Screen extends Abstract_Regular_Screen
{
    protected $force_parent_reload = false;

    /**
     * @param MediaURL $parent_media_url
     * @param object $plugin_cookies
     * @param int $sel_ndx
     * @return array
     */
    public function invalidate_current_folder($parent_media_url, $plugin_cookies, $sel_ndx = -1)
    {
        hd_debug_print(null, true);

        return Action_Factory::update_regular_folder(
                $this->get_folder_range($parent_media_url, 0, $plugin_cookies),
                true,
                $sel_ndx);
    }

    /**
     * @inheritDoc
     */
    public function get_folder_range(MediaURL $media_url, $from_ndx, &$plugin_cookies)
    {
        hd_debug_print(null, true);
        hd_debug_print("from_ndx: $from_ndx, MediaURL: " . $media_url->get_media_url_string(true), true);

        $items = $this->get_all_folder_items($media_url, $plugin_cookies);
        $count = count($items);
        $total = $count - $from_ndx;

        if ($from_ndx < 0) {
            $from_ndx = 0;
        } else if ($from_ndx > $count) {
            $from_ndx = 0;
            $items = array();
        }

        if ($from_ndx > 0) {
            array_splice($items, $count - $from_ndx);
        }

        return array(
            PluginRegularFolderRange::total => $total,
            PluginRegularFolderRange::more_items_available => false,
            PluginRegularFolderRange::from_ndx => (int)$from_ndx,
            PluginRegularFolderRange::count => count($items),
            PluginRegularFolderRange::items => $items
        );
    }

    /**
     * @param MediaURL $media_url
     * @param object $plugin_cookies
     * @return array
     */
    abstract public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies);
}
